<?php

namespace App\Support;

class TalentaHmac
{
    public static function buildHeaders(string $method, string $fullUrl, array $query, string $username, string $secret): array
    {
        $method = strtoupper($method);
        $parsed = parse_url($fullUrl);
        $path   = $parsed['path'] ?? '/';

        $queryString = '';
        if (!empty($query)) {
            $queryString = http_build_query($query, '', '&', PHP_QUERY_RFC3986);
            $path .= '?' . $queryString;
        }

        $date = gmdate('D, d M Y H:i:s') . ' GMT';
        $requestLine = $method . ' ' . $path . ' HTTP/1.1';
        $stringToSign = "date: {$date}\n{$requestLine}";

        $digest    = hash_hmac('sha256', $stringToSign, $secret, true);
        $signature = base64_encode($digest);

        $authHeader = sprintf(
            'hmac username="%s", algorithm="hmac-sha256", headers="date request-line", signature="%s"',
            $username,
            $signature
        );

        return [
            'Authorization' => $authHeader,
            'Date'          => $date,
            'Accept'        => 'application/json',
        ];
    }
}
